using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywołanie programu: Program plik");
      return;
    }
    String plik = args[0];
    FileInfo fi;

    try
    {
      fi = new FileInfo(plik);
    }
    catch(ArgumentException)
    {
      Console.WriteLine(
        "Nazwa {0} zawiera nieprawidłowe znaki.", plik);
      return;
    }

    if(!fi.Exists)
    {
      Console.WriteLine("Plik {0} nie istnieje.", plik);
      return;
    }

    try
    {
      fi.Delete();
    }
    catch(Exception)
    {
      Console.WriteLine("Plik {0} nie może zostać usunięty.", plik);
      return;
    }
    Console.WriteLine("Plik {0} został usunięty.", plik);
  }
}
